/*
 * Decompiled with CFR 0.152.
 */
package org.recompile.mobile;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import javax.imageio.ImageIO;
import javax.microedition.lcdui.Image;
import org.recompile.mobile.Mobile;
import org.recompile.mobile.PlatformGraphics;

public class PlatformImage
extends Image {
    protected BufferedImage canvas;
    protected PlatformGraphics gc;
    public boolean isNull = false;

    public BufferedImage getCanvas() {
        return this.canvas;
    }

    @Override
    public PlatformGraphics getGraphics() {
        return this.gc;
    }

    public PlatformGraphics getNewGraphics() {
        this.createGraphics();
        return this.gc;
    }

    protected void createGraphics() {
        this.gc = new PlatformGraphics(this);
        this.gc.setColor(0);
    }

    public PlatformImage(int Width, int Height) {
        this.width = Width;
        this.height = Height;
        this.canvas = new BufferedImage(Width, Height, 2);
        this.createGraphics();
        this.gc.setColor(0xFFFFFF);
        this.gc.fillRect(0, 0, this.width, this.height);
        this.gc.setColor(0);
        this.platformImage = this;
    }

    public PlatformImage(String name) {
        InputStream stream = Mobile.getPlatform().loader.getMIDletResourceAsStream(name);
        if (stream == null) {
            System.out.println("Couldn't Load Image Stream (can't find " + name + ")");
            this.isNull = true;
        } else {
            try {
                BufferedImage temp = ImageIO.read(stream);
                this.width = temp.getWidth();
                this.height = temp.getHeight();
                this.canvas = new BufferedImage(this.width, this.height, 2);
                this.createGraphics();
                this.gc.drawImage2(temp, 0, 0);
            }
            catch (Exception e) {
                System.out.println("Couldn't Load Image Stream " + name);
                e.printStackTrace();
                this.isNull = true;
            }
        }
        this.platformImage = this;
    }

    public PlatformImage(InputStream stream) {
        try {
            BufferedImage temp = ImageIO.read(stream);
            this.width = temp.getWidth();
            this.height = temp.getHeight();
            this.canvas = new BufferedImage(this.width, this.height, 2);
            this.createGraphics();
            this.gc.drawImage2(temp, 0, 0);
        }
        catch (Exception e) {
            System.out.println("Couldn't Load Image Stream");
            this.isNull = true;
        }
        this.platformImage = this;
    }

    public PlatformImage(Image source) {
        this.width = source.platformImage.width;
        this.height = source.platformImage.height;
        this.canvas = new BufferedImage(this.width, this.height, 2);
        this.createGraphics();
        this.gc.drawImage2(source.platformImage.getCanvas(), 0, 0);
        this.platformImage = this;
    }

    public PlatformImage(byte[] imageData, int imageOffset, int imageLength) {
        try {
            byte[] range = Arrays.copyOfRange(imageData, imageOffset, imageOffset + imageLength);
            ByteArrayInputStream stream = new ByteArrayInputStream(range);
            BufferedImage temp = ImageIO.read(stream);
            this.width = temp.getWidth();
            this.height = temp.getHeight();
            this.canvas = new BufferedImage(this.width, this.height, 2);
            this.createGraphics();
            this.gc.drawImage2(temp, 0, 0);
        }
        catch (Exception e) {
            System.out.println("Couldn't Load Image Data From Byte Array");
            this.canvas = new BufferedImage(Mobile.getPlatform().lcdWidth, Mobile.getPlatform().lcdHeight, 2);
            this.createGraphics();
            this.isNull = true;
        }
        this.platformImage = this;
    }

    public PlatformImage(int[] rgb, int Width, int Height, boolean processAlpha) {
        this.width = Width;
        this.height = Height;
        if (this.width < 1) {
            this.width = 1;
        }
        if (this.height < 1) {
            this.height = 1;
        }
        this.canvas = new BufferedImage(this.width, this.height, 2);
        this.createGraphics();
        this.gc.drawRGB(rgb, 0, this.width, 0, 0, this.width, this.height, true);
        this.platformImage = this;
    }

    public PlatformImage(Image image, int x, int y, int Width, int Height, int transform) {
        BufferedImage sub = image.platformImage.canvas.getSubimage(x, y, Width, Height);
        this.canvas = PlatformImage.transformImage(sub, transform);
        this.createGraphics();
        this.width = this.canvas.getWidth();
        this.height = this.canvas.getHeight();
        this.platformImage = this;
    }

    @Override
    public void getRGB(int[] rgbData, int offset, int scanlength, int x, int y, int width, int height) {
        this.canvas.getRGB(x, y, width, height, rgbData, offset, scanlength);
    }

    public int getARGB(int x, int y) {
        return this.canvas.getRGB(x, y);
    }

    public int getPixel(int x, int y) {
        int[] rgbData = new int[]{0};
        this.canvas.getRGB(x, y, 1, 1, rgbData, 0, 1);
        return rgbData[0];
    }

    public void setPixel(int x, int y, int color) {
        int[] rgbData = new int[]{color};
        this.gc.drawRGB(rgbData, 0, 1, x, y, 1, 1, false);
    }

    public static BufferedImage transformImage(BufferedImage image, int transform) {
        int width = image.getWidth();
        int height = image.getHeight();
        int out_width = width;
        int out_height = height;
        AffineTransform af = new AffineTransform();
        switch (transform) {
            case 0: {
                break;
            }
            case 5: {
                af.translate(height, 0.0);
                af.rotate(1.5707963267948966);
                out_width = height;
                out_height = width;
                break;
            }
            case 3: {
                af.translate(width, height);
                af.rotate(Math.PI);
                break;
            }
            case 6: {
                af.translate(height, 0.0);
                af.rotate(1.5707963267948966);
                out_width = height;
                out_height = width;
                break;
            }
            case 2: {
                af.translate(width, 0.0);
                af.scale(-1.0, 1.0);
                break;
            }
            case 7: {
                af.translate(width, 0.0);
                af.scale(-1.0, 1.0);
                af.translate(height, 0.0);
                af.rotate(1.5707963267948966);
                out_width = height;
                out_height = width;
                break;
            }
            case 1: {
                af.translate(width, 0.0);
                af.scale(-1.0, 1.0);
                af.translate(width, height);
                af.rotate(Math.PI);
                break;
            }
            case 4: {
                af.translate(height, 0.0);
                af.rotate(4.71238898038469);
                af.translate(width, 0.0);
                af.scale(-1.0, 1.0);
                out_width = height;
                out_height = width;
            }
        }
        BufferedImage transimage = new BufferedImage(out_width, out_height, 2);
        Graphics2D gc = transimage.createGraphics();
        gc.drawImage(image, af, null);
        return transimage;
    }
}

