/*
 * Decompiled with CFR 0.152.
 */
package org.recompile.freej2me;

import java.awt.image.RenderedImage;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.imageio.ImageIO;
import org.recompile.mobile.Mobile;

public class ScreenShot {
    public static void takeScreenshot(boolean saveToHomeDir) {
        try {
            String fileName;
            Date date = new Date();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss");
            if (saveToHomeDir) {
                fileName = System.getProperty("user.home") + "/Pictures/Screenshot from " + dateFormat.format(date) + ".png";
            } else {
                String screenshotPath = Mobile.getPlatform().dataPath + "screenshots";
                try {
                    Files.createDirectories(Paths.get(screenshotPath, new String[0]), new FileAttribute[0]);
                }
                catch (Exception e) {
                    System.out.println("Problem Creating Screenshot Path " + screenshotPath);
                    System.out.println(e.getMessage());
                }
                fileName = screenshotPath + "/Screenshot from " + dateFormat.format(date) + ".png";
            }
            File outputfile = new File(fileName);
            ImageIO.write((RenderedImage)Mobile.getPlatform().getLCD(), "png", outputfile);
            System.out.printf("Saved screenshot: %s\n", outputfile.toString());
        }
        catch (Exception e) {
            System.out.println("Error saving screenshot");
            e.printStackTrace();
        }
    }
}

