/*
 * Decompiled with CFR 0.152.
 */
package org.recompile.freej2me;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FilenameFilter;
import javax.imageio.ImageIO;
import org.recompile.freej2me.Config;
import org.recompile.freej2me.ScreenShot;
import org.recompile.mobile.Mobile;
import org.recompile.mobile.MobilePlatform;
import org.recompile.mobile.PlatformImage;

public class FreeJ2ME {
    private Frame main = new Frame("FreeJ2ME");
    private int lcdWidth;
    private int lcdHeight;
    private int scaleFactor = 1;
    private LCD lcd;
    private int xborder;
    private int yborder;
    private PlatformImage img;
    private Config config;
    private boolean useNokiaControls = false;
    private boolean useSiemensControls = false;
    private boolean useMotorolaControls = false;
    private boolean rotateDisplay = false;
    private int limitFPS = 0;

    public static void main(String[] args) {
        FreeJ2ME app = new FreeJ2ME(args);
    }

    public FreeJ2ME(String[] args) {
        this.main.setSize(350, 450);
        this.main.setBackground(new Color(0, 0, 64));
        try {
            this.main.setIconImage(ImageIO.read(this.main.getClass().getResourceAsStream("/org/recompile/icon.png")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.main.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.lcdWidth = 240;
        this.lcdHeight = 320;
        String jarfile = "";
        if (args.length >= 1) {
            jarfile = args[0];
        }
        if (args.length >= 3) {
            this.lcdWidth = Integer.parseInt(args[1]);
            this.lcdHeight = Integer.parseInt(args[2]);
        }
        if (args.length >= 4) {
            this.scaleFactor = Integer.parseInt(args[3]);
        }
        Mobile.setPlatform(new MobilePlatform(this.lcdWidth, this.lcdHeight));
        this.lcd = new LCD();
        this.lcd.setFocusable(true);
        this.main.add(this.lcd);
        this.config = new Config();
        this.config.onChange = new Runnable(){

            @Override
            public void run() {
                FreeJ2ME.this.settingsChanged();
            }
        };
        Mobile.getPlatform().setPainter(new Runnable(){

            @Override
            public void run() {
                FreeJ2ME.this.lcd.paint(FreeJ2ME.this.lcd.getGraphics());
            }
        });
        this.lcd.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (FreeJ2ME.this.config.isRunning) {
                    FreeJ2ME.this.config.keyPressed(FreeJ2ME.this.getMobileKey(e.getKeyCode()));
                } else {
                    Mobile.getPlatform().keyPressed(FreeJ2ME.this.getMobileKey(e.getKeyCode()));
                }
                switch (e.getKeyCode()) {
                    case 107: 
                    case 521: {
                        ++FreeJ2ME.this.scaleFactor;
                        FreeJ2ME.this.main.setSize(FreeJ2ME.this.lcdWidth * FreeJ2ME.this.scaleFactor + FreeJ2ME.this.xborder, FreeJ2ME.this.lcdHeight * FreeJ2ME.this.scaleFactor + FreeJ2ME.this.yborder);
                        break;
                    }
                    case 45: 
                    case 109: {
                        if (FreeJ2ME.this.scaleFactor <= 1) break;
                        --FreeJ2ME.this.scaleFactor;
                        FreeJ2ME.this.main.setSize(FreeJ2ME.this.lcdWidth * FreeJ2ME.this.scaleFactor + FreeJ2ME.this.xborder, FreeJ2ME.this.lcdHeight * FreeJ2ME.this.scaleFactor + FreeJ2ME.this.yborder);
                        break;
                    }
                    case 67: {
                        if (!e.isControlDown()) break;
                        ScreenShot.takeScreenshot(false);
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (FreeJ2ME.this.config.isRunning) {
                    FreeJ2ME.this.config.keyReleased(FreeJ2ME.this.getMobileKey(e.getKeyCode()));
                } else {
                    Mobile.getPlatform().keyReleased(FreeJ2ME.this.getMobileKey(e.getKeyCode()));
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.lcd.addMouseListener(new MouseListener(){

            @Override
            public void mousePressed(MouseEvent e) {
                int x = (int)((double)(e.getX() - FreeJ2ME.this.lcd.cx) * FreeJ2ME.this.lcd.scalex);
                int y = (int)((double)(e.getY() - FreeJ2ME.this.lcd.cy) * FreeJ2ME.this.lcd.scaley);
                Mobile.getPlatform().pointerPressed(x, y);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                int x = (int)((double)(e.getX() - FreeJ2ME.this.lcd.cx) * FreeJ2ME.this.lcd.scalex);
                int y = (int)((double)(e.getY() - FreeJ2ME.this.lcd.cy) * FreeJ2ME.this.lcd.scaley);
                Mobile.getPlatform().pointerReleased(x, y);
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        });
        this.main.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                FreeJ2ME.this.resize();
            }
        });
        this.main.setVisible(true);
        this.main.pack();
        this.resize();
        this.main.setSize(this.lcdWidth * this.scaleFactor + this.xborder, this.lcdHeight * this.scaleFactor + this.yborder);
        if (args.length < 1) {
            FileDialog t = new FileDialog(this.main, "Open JAR File", 0);
            t.setFilenameFilter(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.toLowerCase().endsWith(".jar");
                }
            });
            t.setVisible(true);
            jarfile = new File(t.getDirectory() + File.separator + t.getFile()).toURI().toString();
        }
        if (Mobile.getPlatform().loadJar(jarfile)) {
            this.config.init();
            this.settingsChanged();
            Mobile.getPlatform().runJar();
        } else {
            System.out.println("Couldn't load jar...");
        }
    }

    private void settingsChanged() {
        int w = Integer.parseInt(this.config.settings.get("width"));
        int h = Integer.parseInt(this.config.settings.get("height"));
        this.limitFPS = Integer.parseInt(this.config.settings.get("fps"));
        if (this.limitFPS > 0) {
            this.limitFPS = 1000 / this.limitFPS;
        }
        String sound = this.config.settings.get("sound");
        Mobile.sound = false;
        if (sound.equals("on")) {
            Mobile.sound = true;
        }
        String phone = this.config.settings.get("phone");
        this.useNokiaControls = false;
        this.useSiemensControls = false;
        this.useMotorolaControls = false;
        Mobile.nokia = false;
        Mobile.siemens = false;
        Mobile.motorola = false;
        if (phone.equals("Nokia")) {
            Mobile.nokia = true;
            this.useNokiaControls = true;
        }
        if (phone.equals("Siemens")) {
            Mobile.siemens = true;
            this.useSiemensControls = true;
        }
        if (phone.equals("Motorola")) {
            Mobile.motorola = true;
            this.useMotorolaControls = true;
        }
        if (this.lcdWidth != w || this.lcdHeight != h) {
            this.lcdWidth = w;
            this.lcdHeight = h;
            Mobile.getPlatform().resizeLCD(w, h);
            this.resize();
            this.main.setSize(this.lcdWidth * this.scaleFactor + this.xborder, this.lcdHeight * this.scaleFactor + this.yborder);
        }
    }

    private int getMobileKey(int keycode) {
        if (this.useNokiaControls) {
            switch (keycode) {
                case 38: {
                    return -1;
                }
                case 40: {
                    return -2;
                }
                case 37: {
                    return -3;
                }
                case 39: {
                    return -4;
                }
                case 10: {
                    return -5;
                }
            }
        }
        if (this.useSiemensControls) {
            switch (keycode) {
                case 38: {
                    return -59;
                }
                case 40: {
                    return -60;
                }
                case 37: {
                    return -61;
                }
                case 39: {
                    return -62;
                }
                case 81: {
                    return -1;
                }
                case 87: {
                    return -4;
                }
                case 10: {
                    return -26;
                }
            }
        }
        if (this.useMotorolaControls) {
            switch (keycode) {
                case 38: {
                    return -1;
                }
                case 40: {
                    return -6;
                }
                case 37: {
                    return -2;
                }
                case 39: {
                    return -5;
                }
                case 81: {
                    return -21;
                }
                case 87: {
                    return -22;
                }
                case 10: {
                    return -20;
                }
            }
        }
        switch (keycode) {
            case 48: {
                return 48;
            }
            case 49: {
                return 49;
            }
            case 50: {
                return 50;
            }
            case 51: {
                return 51;
            }
            case 52: {
                return 52;
            }
            case 53: {
                return 53;
            }
            case 54: {
                return 54;
            }
            case 55: {
                return 55;
            }
            case 56: {
                return 56;
            }
            case 57: {
                return 57;
            }
            case 151: {
                return 42;
            }
            case 520: {
                return 35;
            }
            case 96: {
                return 48;
            }
            case 103: {
                return 49;
            }
            case 104: {
                return 50;
            }
            case 105: {
                return 51;
            }
            case 100: {
                return 52;
            }
            case 101: {
                return 53;
            }
            case 102: {
                return 54;
            }
            case 97: {
                return 55;
            }
            case 98: {
                return 56;
            }
            case 99: {
                return 57;
            }
            case 38: {
                return 50;
            }
            case 40: {
                return 56;
            }
            case 37: {
                return 52;
            }
            case 39: {
                return 54;
            }
            case 10: {
                return 53;
            }
            case 81: {
                return -6;
            }
            case 87: {
                return -7;
            }
            case 69: {
                return 42;
            }
            case 82: {
                return 35;
            }
            case 65: {
                return -1;
            }
            case 90: {
                return -2;
            }
            case 27: {
                this.config.start();
            }
        }
        return keycode;
    }

    private void resize() {
        this.xborder = this.main.getInsets().left + this.main.getInsets().right;
        this.yborder = this.main.getInsets().top + this.main.getInsets().bottom;
        double vw = (this.main.getWidth() - this.xborder) * 1;
        double vh = (this.main.getHeight() - this.yborder) * 1;
        double nw = this.lcdWidth;
        double nh = this.lcdHeight;
        nw = vw;
        nh = nw * ((double)this.lcdHeight / (double)this.lcdWidth);
        if (nh > vh) {
            nh = vh;
            nw = nh * ((double)this.lcdWidth / (double)this.lcdHeight);
        }
        this.lcd.updateScale((int)nw, (int)nh);
    }

    private class LCD
    extends Canvas {
        public int cx = 0;
        public int cy = 0;
        public int cw = 240;
        public int ch = 320;
        public double scalex = 1.0;
        public double scaley = 1.0;

        private LCD() {
        }

        public void updateScale(int vw, int vh) {
            this.cx = (this.getWidth() - vw) / 2;
            this.cy = (this.getHeight() - vh) / 2;
            this.cw = vw;
            this.ch = vh;
            this.scalex = (double)FreeJ2ME.this.lcdWidth / (double)vw;
            this.scaley = (double)FreeJ2ME.this.lcdHeight / (double)vh;
        }

        @Override
        public void paint(Graphics g) {
            try {
                Graphics2D cgc = (Graphics2D)this.getGraphics();
                if (FreeJ2ME.this.config.isRunning) {
                    g.drawImage(FreeJ2ME.this.config.getLCD(), this.cx, this.cy, this.cw, this.ch, null);
                } else {
                    g.drawImage(Mobile.getPlatform().getLCD(), this.cx, this.cy, this.cw, this.ch, null);
                    if (FreeJ2ME.this.limitFPS > 0) {
                        Thread.sleep(FreeJ2ME.this.limitFPS);
                    }
                }
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }
}

