/*
 * Decompiled with CFR 0.152.
 */
package org.recompile.freej2me;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Timer;
import java.util.TimerTask;
import org.recompile.freej2me.ScreenShot;
import org.recompile.mobile.Mobile;
import org.recompile.mobile.MobilePlatform;

public class Anbu {
    private SDL sdl;
    private int lcdWidth = 240;
    private int lcdHeight = 320;
    private Runnable painter;

    public static void main(String[] args) {
        Anbu app = new Anbu(args);
    }

    public Anbu(String[] args) {
        if (args.length < 3) {
            System.out.println("Insufficient parameters provided");
            return;
        }
        this.lcdWidth = Integer.parseInt(args[1]);
        this.lcdHeight = Integer.parseInt(args[2]);
        Mobile.setPlatform(new MobilePlatform(this.lcdWidth, this.lcdHeight));
        this.painter = new Runnable(){

            @Override
            public void run() {
                try {
                    int[] data = Mobile.getPlatform().getLCD().getRGB(0, 0, Anbu.this.lcdWidth, Anbu.this.lcdHeight, null, 0, Anbu.this.lcdWidth);
                    byte[] frame = new byte[data.length * 3];
                    int cb = 0;
                    for (int i = 0; i < data.length; ++i) {
                        frame[cb + 0] = (byte)(data[i] >> 16);
                        frame[cb + 1] = (byte)(data[i] >> 8);
                        frame[cb + 2] = (byte)data[i];
                        cb += 3;
                    }
                    Anbu.this.sdl.frame.write(frame);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        Mobile.getPlatform().setPainter(this.painter);
        String file = Anbu.getFormattedLocation(args[0]);
        System.out.println(file);
        if (Mobile.getPlatform().loadJar(file)) {
            this.sdl = new SDL();
            this.sdl.start(args);
            Mobile.getPlatform().runJar();
        } else {
            System.out.println("Couldn't load jar...");
            System.exit(0);
        }
    }

    private static String getFormattedLocation(String loc) {
        if (loc.startsWith("file://") || loc.startsWith("http://")) {
            return loc;
        }
        File file = new File(loc);
        if (!file.exists() || file.isDirectory()) {
            System.out.println("File not found...");
            System.exit(0);
        }
        return "file://" + file.getAbsolutePath();
    }

    private class SDL {
        private Timer keytimer;
        private TimerTask keytask;
        private Process proc;
        private InputStream keys;
        public OutputStream frame;

        private SDL() {
        }

        public void start(String[] args) {
            try {
                args[0] = "/usr/local/bin/sdl_interface";
                this.proc = new ProcessBuilder(args).start();
                this.keys = this.proc.getInputStream();
                this.frame = this.proc.getOutputStream();
                this.keytimer = new Timer();
                this.keytask = new SDLKeyTimerTask();
                this.keytimer.schedule(this.keytask, 0L, 5L);
            }
            catch (Exception e) {
                System.out.println("Failed to start sdl_interface");
                System.out.println(e.getMessage());
                System.exit(0);
            }
        }

        public void stop() {
            this.proc.destroy();
            this.keytimer.cancel();
        }

        private int getMobileKey(int keycode) {
            switch (keycode) {
                case 48: {
                    return 48;
                }
                case 49: {
                    return 49;
                }
                case 50: {
                    return 50;
                }
                case 51: {
                    return 51;
                }
                case 52: {
                    return 52;
                }
                case 53: {
                    return 53;
                }
                case 54: {
                    return 54;
                }
                case 55: {
                    return 55;
                }
                case 56: {
                    return 56;
                }
                case 57: {
                    return 57;
                }
                case 42: {
                    return 42;
                }
                case 35: {
                    return 35;
                }
                case 1073741906: {
                    return 50;
                }
                case 1073741905: {
                    return 56;
                }
                case 0x40000050: {
                    return 52;
                }
                case 0x4000004F: {
                    return 54;
                }
                case 13: {
                    return 53;
                }
                case 113: {
                    return -6;
                }
                case 119: {
                    return -7;
                }
                case 101: {
                    return 42;
                }
                case 114: {
                    return 35;
                }
                case 1073741913: {
                    return 55;
                }
                case 1073741914: {
                    return 56;
                }
                case 1073741915: {
                    return 57;
                }
                case 1073741916: {
                    return 52;
                }
                case 1073741917: {
                    return 53;
                }
                case 1073741918: {
                    return 54;
                }
                case 1073741919: {
                    return 49;
                }
                case 0x40000060: {
                    return 50;
                }
                case 1073741921: {
                    return 51;
                }
                case 1073741922: {
                    return 48;
                }
                case -1: {
                    System.exit(0);
                }
                case 27: {
                    System.exit(0);
                }
                case 112: {
                    ScreenShot.takeScreenshot(true);
                }
            }
            return keycode;
        }

        private int getMobileKeyPad(int keycode) {
            switch (keycode) {
                case 3: {
                    return 48;
                }
                case 2: {
                    return 53;
                }
                case 0: {
                    return 42;
                }
                case 1: {
                    return 35;
                }
                case 4: {
                    return 49;
                }
                case 5: {
                    return 51;
                }
                case 6: {
                    return -6;
                }
                case 7: {
                    return -7;
                }
            }
            return keycode;
        }

        private int getMobileKeyJoy(int keycode) {
            switch (keycode) {
                case 4: {
                    return 50;
                }
                case 1: {
                    return 52;
                }
                case 2: {
                    return 54;
                }
                case 8: {
                    return 56;
                }
            }
            return keycode;
        }

        private class SDLKeyTimerTask
        extends TimerTask {
            private int bin;
            private byte[] din = new byte[6];
            private int count = 0;
            private int code;

            private SDLKeyTimerTask() {
            }

            @Override
            public void run() {
                try {
                    while (true) {
                        this.bin = SDL.this.keys.read();
                        if (this.bin == -1) {
                            return;
                        }
                        this.din[this.count] = (byte)(this.bin & 0xFF);
                        ++this.count;
                        if (this.count != 5) continue;
                        this.count = 0;
                        this.code = this.din[1] << 24 | this.din[2] << 16 | this.din[3] << 8 | this.din[4];
                        switch (this.din[0]) {
                            case 0: {
                                Mobile.getPlatform().keyReleased(SDL.this.getMobileKey(this.code));
                                break;
                            }
                            case 1: {
                                Mobile.getPlatform().keyPressed(SDL.this.getMobileKey(this.code));
                                break;
                            }
                            case 2: {
                                Mobile.getPlatform().keyReleased(SDL.this.getMobileKeyPad(this.code));
                                break;
                            }
                            case 3: {
                                Mobile.getPlatform().keyPressed(SDL.this.getMobileKeyPad(this.code));
                                break;
                            }
                            case 4: {
                                Mobile.getPlatform().keyReleased(SDL.this.getMobileKeyJoy(this.code));
                                break;
                            }
                            case 5: {
                                Mobile.getPlatform().keyPressed(SDL.this.getMobileKeyJoy(this.code));
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    return;
                }
            }
        }
    }
}

