/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui.game;

import java.util.ArrayList;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.TiledLayer;

public class Sprite
extends Layer {
    public static final int TRANS_MIRROR = 2;
    public static final int TRANS_MIRROR_ROT180 = 1;
    public static final int TRANS_MIRROR_ROT270 = 4;
    public static final int TRANS_MIRROR_ROT90 = 7;
    public static final int TRANS_NONE = 0;
    public static final int TRANS_ROT180 = 3;
    public static final int TRANS_ROT270 = 6;
    public static final int TRANS_ROT90 = 5;
    private int refX = 0;
    private int refY = 0;
    private int hitX;
    private int hitY;
    private int hitWidth;
    private int hitHeight;
    private int transform;
    private ArrayList<Integer> sequence = new ArrayList();
    public Image sprite;
    private int frame = 0;
    private int frameWidth;
    private int frameHeight;
    private int frameCount = 1;
    private int imgWidth;
    private int imgHeight;
    public int rowCount = 1;
    public int colCount = 1;

    public Sprite() {
        System.out.println("Sprite A");
    }

    public Sprite(Image img) {
        this.imgWidth = img.getWidth();
        this.imgHeight = img.getHeight();
        this.frameWidth = this.imgWidth;
        this.frameHeight = this.imgHeight;
        this.colCount = 1;
        this.rowCount = 1;
        this.frameCount = 1;
        this.setImage(img, this.imgWidth, this.imgHeight);
    }

    public Sprite(Image img, int frameW, int frameH) {
        this.imgWidth = img.getWidth();
        this.imgHeight = img.getHeight();
        this.frameWidth = frameW;
        this.frameHeight = frameH;
        this.colCount = this.imgWidth / this.frameWidth;
        this.rowCount = this.imgHeight / this.frameHeight;
        this.frameCount = this.rowCount * this.colCount;
        this.setImage(img, this.frameWidth, this.frameHeight);
    }

    public Sprite(Sprite s) {
        System.out.println("Sprite D");
        this.imgWidth = s.sprite.getWidth();
        this.imgHeight = s.sprite.getHeight();
        this.frameWidth = this.imgWidth;
        this.frameHeight = this.imgHeight;
        this.colCount = 1;
        this.rowCount = 1;
        this.frameCount = 1;
        this.setImage(s.sprite, this.imgWidth, this.imgHeight);
    }

    public boolean collidesWith(Image image, int x, int y, boolean pixelLevel) {
        return false;
    }

    public boolean collidesWith(Sprite s, boolean pixelLevel) {
        int Ax = this.x - this.refX + this.hitX;
        int Ay = this.y - this.refY + this.hitY;
        int Aw = this.hitWidth;
        int Ah = this.hitHeight;
        int Bx = s.getX() - s.getRefPixelX() + s.getHitX();
        int By = s.getY() - s.getRefPixelY() + s.getHitY();
        int Bw = s.getHitWidth();
        int Bh = s.getHitHeight();
        return Ax + Aw > Bx && Ax < Bx + Bw && Ay + Ah > By && Ay < By + Bh;
    }

    public boolean collidesWith(TiledLayer t, boolean pixelLevel) {
        return false;
    }

    public void defineCollisionRectangle(int x, int y, int width, int height) {
        this.hitX = x;
        this.hitY = y;
        this.hitWidth = width;
        this.hitHeight = height;
    }

    public void defineReferencePixel(int x, int y) {
        this.refX = x;
        this.refY = y;
    }

    public int getFrame() {
        return this.frame;
    }

    public int getFrameSequenceLength() {
        return this.sequence.size();
    }

    public int getRawFrameCount() {
        return this.frameCount;
    }

    public int getRefPixelX() {
        return this.refX;
    }

    public int getRefPixelY() {
        return this.refY;
    }

    public void nextFrame() {
        this.frame = this.frame < this.sequence.size() - 1 ? ++this.frame : 0;
    }

    @Override
    public void paint(Graphics g) {
        try {
            int f = this.sequence.get(this.frame);
            int r = this.frameHeight * (f / this.colCount);
            int c = this.frameWidth * (f % this.colCount);
            g.drawRegion(this.sprite, c, r, this.frameWidth, this.frameHeight, this.transform, this.x - this.refX, this.y - this.refY, 0);
        }
        catch (Exception e) {
            System.out.println("Problem drawing sprite");
        }
    }

    public void prevFrame() {
        this.frame = this.frame > 0 ? --this.frame : this.sequence.size() - 1;
    }

    public void setFrame(int sequenceIndex) {
        if (sequenceIndex < 0 || sequenceIndex >= this.sequence.size()) {
            throw new IndexOutOfBoundsException();
        }
        this.frame = sequenceIndex;
    }

    public void setFrameSequence(int[] fsequence) {
        try {
            this.frame = 0;
            this.sequence.clear();
            for (int i = 0; i < fsequence.length; ++i) {
                this.sequence.add(i, fsequence[i]);
            }
        }
        catch (Exception e) {
            System.out.println("Problem with Sprite.setFrameSequence");
        }
    }

    public void setImage(Image img, int frameW, int frameH) {
        this.sprite = img;
        this.frameWidth = frameW;
        this.frameHeight = frameH;
        this.hitX = 0;
        this.hitY = 0;
        this.hitWidth = this.frameWidth;
        this.hitHeight = this.frameHeight;
        double spriteW = this.sprite.platformImage.width;
        double spriteH = this.sprite.platformImage.height;
        this.colCount = (int)Math.floor(spriteW / (double)frameW);
        this.rowCount = (int)Math.floor(spriteH / (double)frameH);
        this.frameCount = this.colCount * this.rowCount;
        this.sequence.clear();
        for (int i = 0; i < this.frameCount; ++i) {
            this.sequence.add(i, i);
        }
    }

    public void setRefPixelPosition(int x, int y) {
        this.refX = x;
        this.refY = y;
    }

    public void setTransform(int value) {
        this.transform = value;
    }

    public int getHitX() {
        return this.hitX;
    }

    public int getHitY() {
        return this.hitY;
    }

    public int getHitWidth() {
        return this.hitWidth;
    }

    public int getHitHeight() {
        return this.hitHeight;
    }
}

