/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui.game;

import java.awt.Shape;
import java.util.ArrayList;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Layer;
import org.recompile.mobile.Mobile;
import org.recompile.mobile.PlatformGraphics;

public class LayerManager {
    protected ArrayList<Layer> layers = new ArrayList();
    protected Image canvas;
    protected PlatformGraphics gc;
    protected Shape clip;
    protected int x;
    protected int y;
    protected int width;
    protected int height;

    public LayerManager() {
        this.width = Mobile.getPlatform().lcdWidth;
        this.height = Mobile.getPlatform().lcdHeight;
        this.canvas = Image.createImage(this.width, this.height);
        this.gc = this.canvas.platformImage.getGraphics();
    }

    public void append(Layer l) {
        this.layers.add(l);
    }

    public Layer getLayerAt(int index) {
        return this.layers.get(index);
    }

    public int getSize() {
        return this.layers.size();
    }

    public void insert(Layer l, int index) {
        this.layers.add(index, l);
    }

    public void paint(Graphics g, int xdest, int ydest) {
        for (int i = 0; i < this.layers.size(); ++i) {
            this.drawLayer(g, xdest, ydest, this.layers.get(i));
        }
    }

    private void drawLayer(Graphics g, int dx, int dy, Layer l) {
        if (l.isVisible()) {
            l.render();
            g.drawRegion(l.getLayerImage(), 0, 0, l.getLayerImage().getWidth(), l.getLayerImage().getHeight(), 0, dx + this.x + l.getX(), dy + this.y + l.getY(), 20);
        }
    }

    public void remove(Layer l) {
        this.layers.remove(l);
    }

    public void setViewWindow(int wx, int wy, int wwidth, int wheight) {
        this.x = wx;
        this.y = wy;
        this.width = wwidth;
        this.height = wheight;
    }
}

