/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mid.m3d;

import com.nokia.mid.m3d.Texture;
import javax.microedition.lcdui.Graphics;
import org.recompile.mobile.PlatformGraphics;
import org.recompile.mobile.PlatformImage;

public class M3D {
    private double[] matrix = new double[16];
    private double[] stack = new double[16];
    private double[] tempm = new double[16];
    private double[] tempr = new double[16];
    private double[] tempt = new double[16];
    private double[] temps = new double[16];
    private double[] rotm = new double[16];
    private double[] projm = new double[16];
    private int width;
    private int height;
    private Texture texture;
    private boolean boundTexture = false;
    private double[] verts = new double[256];
    private double[] UVs = new double[256];
    private double[] faces = new double[384];
    private double[] faceUVs = new double[384];
    private int[] debugColors = new int[384];
    int debugColor = 0xFF0000;
    private int vertCount;
    private int faceCount;
    private PlatformImage platformImage;
    private PlatformGraphics gc;
    private double[] zbuffer;
    private double near;
    private double far;
    private int color = -16777216;
    private int clearcolor = -1;

    private M3D() {
    }

    public static M3D createInstance() {
        return new M3D();
    }

    public void setupBuffers(int flags, int displayWidth, int displayHeight) {
        this.width = displayWidth;
        this.height = displayHeight;
        this.platformImage = new PlatformImage(this.width, this.height);
        this.gc = this.platformImage.getGraphics();
        this.zbuffer = new double[this.width * this.height];
        this.clear(0);
    }

    public void removeBuffers() {
    }

    public void cullFace(int a) {
    }

    public void viewport(int x, int y, int w, int h) {
    }

    public void clear(int a) {
        this.gc.setColor(this.clearcolor);
        this.gc.fillRect(0, 0, this.width, this.height);
        this.gc.setColor(this.color);
        this.identity(this.matrix);
        this.identity(this.stack);
        for (int i = 0; i < this.zbuffer.length; ++i) {
            this.zbuffer[i] = -128.0;
        }
        this.boundTexture = false;
    }

    public void matrixMode(int mode) {
    }

    public void loadIdentity() {
        this.identity(this.matrix);
    }

    public void frustumxi(int left, int right, int top, int bottom, int nearclip, int farclip) {
        double r = (double)right / 65536.0;
        double l = (double)left / 65536.0;
        double t = (double)top / 65536.0;
        double b = (double)bottom / 65536.0;
        double n = (double)nearclip / 65536.0;
        double f = (double)farclip / 65536.0;
        this.near = -n;
        this.far = -f;
        this.projection(this.projm, r - l, t - b, n, f);
    }

    public void scalexi(int X, int Y, int Z) {
        double x = (double)X / 65536.0;
        double y = (double)Y / 65536.0;
        double z = (double)Z / 65536.0;
        this.temps[0] = x;
        this.temps[1] = 0.0;
        this.temps[2] = 0.0;
        this.temps[3] = 0.0;
        this.temps[4] = 0.0;
        this.temps[5] = y;
        this.temps[6] = 0.0;
        this.temps[7] = 0.0;
        this.temps[8] = 0.0;
        this.temps[9] = 0.0;
        this.temps[10] = z;
        this.temps[11] = 0.0;
        this.temps[12] = 0.0;
        this.temps[13] = 0.0;
        this.temps[14] = 0.0;
        this.temps[15] = 1.0;
        this.matmul(this.temps, this.matrix);
        this.clone(this.matrix, this.temps);
    }

    public void translatexi(int X, int Y, int Z) {
        double x = (double)X / 65536.0;
        double y = (double)Y / 65536.0;
        double z = (double)Z / 65536.0;
        this.tempt[0] = 1.0;
        this.tempt[1] = 0.0;
        this.tempt[2] = 0.0;
        this.tempt[3] = 0.0;
        this.tempt[4] = 0.0;
        this.tempt[5] = 1.0;
        this.tempt[6] = 0.0;
        this.tempt[7] = 0.0;
        this.tempt[8] = 0.0;
        this.tempt[9] = 0.0;
        this.tempt[10] = 1.0;
        this.tempt[11] = 0.0;
        this.tempt[12] = x;
        this.tempt[13] = y;
        this.tempt[14] = z;
        this.tempt[15] = 1.0;
        this.matmul(this.tempt, this.matrix);
        this.clone(this.matrix, this.tempt);
    }

    public void rotatexi(int Angle, int X, int Y, int Z) {
        double a = (double)Angle / 65536.0 * 0.0174533;
        if (X != 0) {
            this.tempr[0] = 1.0;
            this.tempr[1] = 0.0;
            this.tempr[2] = 0.0;
            this.tempr[3] = 0.0;
            this.tempr[4] = 0.0;
            this.tempr[5] = Math.cos(a);
            this.tempr[6] = Math.sin(a);
            this.tempr[7] = 0.0;
            this.tempr[8] = 0.0;
            this.tempr[9] = -Math.sin(a);
            this.tempr[10] = Math.cos(a);
            this.tempr[11] = 0.0;
            this.tempr[12] = 0.0;
            this.tempr[13] = 0.0;
            this.tempr[14] = 0.0;
            this.tempr[15] = 1.0;
            this.clone(this.rotm, this.tempr);
        }
        if (Y != 0) {
            this.tempr[0] = Math.cos(a);
            this.tempr[1] = 0.0;
            this.tempr[2] = -Math.sin(a);
            this.tempr[3] = 0.0;
            this.tempr[4] = 0.0;
            this.tempr[5] = 1.0;
            this.tempr[6] = 0.0;
            this.tempr[7] = 0.0;
            this.tempr[8] = Math.sin(a);
            this.tempr[9] = 0.0;
            this.tempr[10] = Math.cos(a);
            this.tempr[11] = 0.0;
            this.tempr[12] = 0.0;
            this.tempr[13] = 0.0;
            this.tempr[14] = 0.0;
            this.tempr[15] = 1.0;
            this.clone(this.rotm, this.tempr);
        }
        if (Z != 0) {
            this.tempr[0] = Math.cos(a);
            this.tempr[1] = Math.sin(a);
            this.tempr[2] = 0.0;
            this.tempr[3] = 0.0;
            this.tempr[4] = -Math.sin(a);
            this.tempr[5] = Math.cos(a);
            this.tempr[6] = 0.0;
            this.tempr[7] = 0.0;
            this.tempr[8] = 0.0;
            this.tempr[9] = 0.0;
            this.tempr[10] = 1.0;
            this.tempr[11] = 0.0;
            this.tempr[12] = 0.0;
            this.tempr[13] = 0.0;
            this.tempr[14] = 0.0;
            this.tempr[15] = 1.0;
            this.clone(this.rotm, this.tempr);
        }
        this.matmul(this.rotm, this.matrix);
        this.clone(this.matrix, this.rotm);
    }

    public void pushMatrix() {
        this.clone(this.stack, this.matrix);
    }

    public void popMatrix() {
        this.clone(this.matrix, this.stack);
    }

    public void color4ub(byte r, byte g, byte b, byte a) {
        this.color = 0xFF000000 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public void clearColor4ub(byte r, byte g, byte b, byte a) {
        this.clearcolor = 0xFF000000 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public void vertexPointerub(int a, int b, byte[] vertices) {
        int i = 0;
        for (i = 0; i < vertices.length; i += 3) {
            this.verts[i] = vertices[i];
            this.verts[i + 1] = vertices[i + 1];
            this.verts[i + 2] = vertices[i + 2];
        }
        this.vertCount = vertices.length;
    }

    private void addFaces(double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3, double u1, double v1, double u2, double v2, double u3, double v3) {
        this.debugColor = this.color;
        if (z1 <= this.near && z2 <= this.near && z3 <= this.near) {
            this.addFace(x1, y1, z1, x2, y2, z2, x3, y3, z3, u1, v1, u2, v2, u3, v3);
            return;
        }
        if (z1 > this.near && z2 <= this.near && z3 <= this.near) {
            this.addFace2(x2, y2, z2, x3, y3, z3, x1, y1, z1, u2, v2, u3, v3, u1, v1);
            return;
        }
        if (z1 <= this.near && z2 > this.near && z3 <= this.near) {
            this.addFace2(x1, y1, z1, x3, y3, z3, x2, y2, z2, u1, v1, u3, v3, u2, v2);
            return;
        }
        if (z1 <= this.near && z2 <= this.near && z3 > this.near) {
            this.addFace2(x1, y1, z1, x2, y2, z2, x3, y3, z3, u1, v1, u2, v2, u3, v3);
            return;
        }
        if (z1 > this.near && z2 > this.near && z3 <= this.near) {
            this.addFace1(x3, y3, z3, x1, y1, z1, x2, y2, z2, u3, v3, u1, v1, u2, v2);
            return;
        }
        if (z1 > this.near && z2 <= this.near && z3 > this.near) {
            this.addFace1(x2, y2, z2, x1, y1, z1, x3, y3, z3, u2, v2, u1, v1, u3, v3);
            return;
        }
        if (z1 <= this.near && z2 > this.near && z3 > this.near) {
            this.addFace1(x1, y1, z1, x2, y2, z2, x3, y3, z3, u1, v1, u2, v2, u3, v3);
            return;
        }
    }

    private void addFace2(double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3, double u1, double v1, double u2, double v2, double u3, double v3) {
        double dx = x3 - x1;
        double dy = y3 - y1;
        double dz = z1 - z3;
        double x4 = x1 + dx / dz * (z1 - this.near);
        double y4 = y1 + dy / dz * (z1 - this.near);
        double z4 = this.near;
        dx = x3 - x2;
        dy = y3 - y2;
        dz = z2 - z3;
        double x5 = x2 + dx / dz * (z2 - this.near);
        double y5 = y2 + dy / dz * (z2 - this.near);
        double z5 = this.near;
        this.addFace(x1, y1, z1, x2, y2, z2, x5, y5, z5, u1, v1, u2, v2, u3, v3);
        this.addFace(x1, y1, z1, x5, y5, z5, x4, y4, z4, u1, v1, u2, v2, u3, v3);
    }

    private void addFace1(double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3, double u1, double v1, double u2, double v2, double u3, double v3) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        double dz = z1 - z2;
        x2 = x1 + dx / dz * (z1 - this.near);
        y2 = y1 + dy / dz * (z1 - this.near);
        z2 = this.near;
        dx = x3 - x1;
        dy = y3 - y1;
        dz = z1 - z3;
        x3 = x1 + dx / dz * (z1 - this.near);
        y3 = y1 + dy / dz * (z1 - this.near);
        z3 = this.near;
        this.addFace(x1, y1, z1, x2, y2, z2, x3, y3, z3, u1, v1, u2, v2, u3, v3);
    }

    private void addFace(double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3, double u1, double v1, double u2, double v2, double u3, double v3) {
        this.faces[this.faceCount * 3] = x1;
        this.faces[this.faceCount * 3 + 1] = y1;
        this.faces[this.faceCount * 3 + 2] = z1;
        this.faceUVs[this.faceCount * 2] = u1;
        this.faceUVs[this.faceCount * 2 + 1] = v1;
        ++this.faceCount;
        this.faces[this.faceCount * 3] = x2;
        this.faces[this.faceCount * 3 + 1] = y2;
        this.faces[this.faceCount * 3 + 2] = z2;
        this.faceUVs[this.faceCount * 2] = u2;
        this.faceUVs[this.faceCount * 2 + 1] = v2;
        ++this.faceCount;
        this.faces[this.faceCount * 3] = x3;
        this.faces[this.faceCount * 3 + 1] = y3;
        this.faces[this.faceCount * 3 + 2] = z3;
        this.faceUVs[this.faceCount * 2] = u3;
        this.faceUVs[this.faceCount * 2 + 1] = v3;
        ++this.faceCount;
    }

    public void drawElementsub(int A, int B, byte[] facelist) {
        double z3;
        double y3;
        double x3;
        double z2;
        double y2;
        double x2;
        double z1;
        double y1;
        double x1;
        int i;
        double ox = this.width / 2;
        double oy = this.height / 2;
        double v3 = 0.0;
        double u3 = 0.0;
        double v2 = 0.0;
        double u2 = 0.0;
        double v1 = 0.0;
        double u1 = 0.0;
        this.gc.setColor(this.color);
        this.applyMatrix(this.matrix);
        this.faceCount = 0;
        for (i = 0; i < facelist.length; i += 3) {
            x1 = this.verts[facelist[i] * 3];
            y1 = this.verts[facelist[i] * 3 + 1];
            z1 = this.verts[facelist[i] * 3 + 2];
            x2 = this.verts[facelist[i + 1] * 3];
            y2 = this.verts[facelist[i + 1] * 3 + 1];
            z2 = this.verts[facelist[i + 1] * 3 + 2];
            x3 = this.verts[facelist[i + 2] * 3];
            y3 = this.verts[facelist[i + 2] * 3 + 1];
            z3 = this.verts[facelist[i + 2] * 3 + 2];
            if (z1 > this.near && z2 > this.near && z3 > this.near) continue;
            u1 = this.UVs[facelist[i] * 2];
            v1 = this.UVs[facelist[i] * 2 + 1];
            u2 = this.UVs[facelist[i + 1] * 2];
            v2 = this.UVs[facelist[i + 1] * 2 + 1];
            u3 = this.UVs[facelist[i + 2] * 2];
            v3 = this.UVs[facelist[i + 2] * 2 + 1];
            this.addFaces(x1, y1, z1, x2, y2, z2, x3, y3, z3, u1, v1, u2, v2, u3, v3);
        }
        for (i = 0; i < this.faceCount; ++i) {
            double x = this.faces[i * 3];
            double y = this.faces[i * 3 + 1];
            double z = this.faces[i * 3 + 2];
            double w = 1.0;
            x1 = x * this.projm[0] + y * this.projm[4] + z * this.projm[8] + this.projm[12];
            y1 = x * this.projm[1] + y * this.projm[5] + z * this.projm[9] + this.projm[13];
            z1 = x * this.projm[2] + y * this.projm[6] + z * this.projm[10] + this.projm[14];
            double w1 = x * this.projm[3] + y * this.projm[7] + z * this.projm[11] + this.projm[15];
            if (w1 == 1.0) continue;
            this.faces[i * 3] = x1 / w1;
            this.faces[i * 3 + 1] = y1 / w1;
        }
        for (i = 0; i < this.faceCount; i += 3) {
            x1 = this.faces[i * 3];
            y1 = this.faces[i * 3 + 1];
            z1 = this.faces[i * 3 + 2];
            x2 = this.faces[i * 3 + 3];
            y2 = this.faces[i * 3 + 4];
            z2 = this.faces[i * 3 + 5];
            x3 = this.faces[i * 3 + 6];
            y3 = this.faces[i * 3 + 7];
            z3 = this.faces[i * 3 + 8];
            u1 = this.faceUVs[i * 2];
            v1 = this.faceUVs[i * 2 + 1];
            u2 = this.faceUVs[i * 2 + 2];
            v2 = this.faceUVs[i * 2 + 3];
            u3 = this.faceUVs[i * 2 + 4];
            v3 = this.faceUVs[i * 2 + 5];
            x1 = x1 * ox + ox;
            x2 = x2 * ox + ox;
            x3 = x3 * ox + ox;
            y1 = y1 * oy + oy;
            y2 = y2 * oy + oy;
            y3 = y3 * oy + oy;
            if (this.boundTexture) {
                this.texture.setUVs((int)u1, (int)v1, (int)u2, (int)v2, (int)u3, (int)v3);
                this.texture.mapto((int)x1, (int)y1, (int)x2, (int)y2, (int)x3, (int)y3);
            }
            this.fillTriangle(x1, y1, z1, x2, y2, z2, x3, y3, z3);
        }
    }

    public void drawArrays(int a, int b, int c) {
        this.gc.setColor(this.color);
        this.applyMatrix(this.matrix);
        double y = this.verts[1];
        double z = this.verts[2];
        y = y * this.projm[5] / -z;
        double oy = this.height / 2;
        y = y * oy + oy;
        this.gc.fillRect(0, (int)y, this.width, this.height - (int)y);
    }

    public void bindTexture(int a, Texture b) {
        this.texture = b;
        this.boundTexture = true;
    }

    public void texCoordPointerub(int a, int b, byte[] uvs) {
        for (int i = 0; i < uvs.length; ++i) {
            this.UVs[i] = uvs[i];
        }
    }

    public void enableClientState(int flags) {
    }

    public void disableClientState(int flags) {
    }

    public void enable(int feature) {
    }

    public void disable(int feature) {
    }

    public void blit(Graphics g, int x, int y, int w, int h) {
        g.drawImage(this.platformImage, x, y, 20);
    }

    private void identity(double[] m) {
        m[0] = 1.0;
        m[1] = 0.0;
        m[2] = 0.0;
        m[3] = 0.0;
        m[4] = 0.0;
        m[5] = 1.0;
        m[6] = 0.0;
        m[7] = 0.0;
        m[8] = 0.0;
        m[9] = 0.0;
        m[10] = 1.0;
        m[11] = 0.0;
        m[12] = 0.0;
        m[13] = 0.0;
        m[14] = 0.0;
        m[15] = 1.0;
    }

    private void projection(double[] m, double w, double h, double n, double f) {
        double d = -(f + n) / (f - n);
        double e = -(2.0 * f * n) / (f - n);
        m[0] = 2.0 * n / w;
        m[1] = 0.0;
        m[2] = 0.0;
        m[3] = 0.0;
        m[4] = 0.0;
        m[5] = 2.0 * n / h;
        m[6] = 0.0;
        m[7] = 0.0;
        m[8] = 0.0;
        m[9] = 0.0;
        m[10] = d;
        m[11] = -1.0;
        m[12] = 0.0;
        m[13] = 0.0;
        m[14] = e;
        m[15] = 0.0;
    }

    private void clone(double[] m1, double[] m2) {
        for (int i = 0; i < 16; ++i) {
            m1[i] = m2[i];
        }
    }

    private void matmul(double[] m1, double[] m2) {
        this.tempm[0] = m1[0] * m2[0] + m1[1] * m2[4] + m1[2] * m2[8] + m1[3] * m2[12];
        this.tempm[1] = m1[0] * m2[1] + m1[1] * m2[5] + m1[2] * m2[9] + m1[3] * m2[13];
        this.tempm[2] = m1[0] * m2[2] + m1[1] * m2[6] + m1[2] * m2[10] + m1[3] * m2[14];
        this.tempm[3] = m1[0] * m2[3] + m1[1] * m2[7] + m1[2] * m2[11] + m1[3] * m2[15];
        this.tempm[4] = m1[4] * m2[0] + m1[5] * m2[4] + m1[6] * m2[8] + m1[7] * m2[12];
        this.tempm[5] = m1[4] * m2[1] + m1[5] * m2[5] + m1[6] * m2[9] + m1[7] * m2[13];
        this.tempm[6] = m1[4] * m2[2] + m1[5] * m2[6] + m1[6] * m2[10] + m1[7] * m2[14];
        this.tempm[7] = m1[4] * m2[3] + m1[5] * m2[7] + m1[6] * m2[11] + m1[7] * m2[15];
        this.tempm[8] = m1[8] * m2[0] + m1[9] * m2[4] + m1[10] * m2[8] + m1[11] * m2[12];
        this.tempm[9] = m1[8] * m2[1] + m1[9] * m2[5] + m1[10] * m2[9] + m1[11] * m2[13];
        this.tempm[10] = m1[8] * m2[2] + m1[9] * m2[6] + m1[10] * m2[10] + m1[11] * m2[14];
        this.tempm[11] = m1[8] * m2[3] + m1[9] * m2[7] + m1[10] * m2[11] + m1[11] * m2[15];
        this.tempm[12] = m1[12] * m2[0] + m1[13] * m2[4] + m1[14] * m2[8] + m1[15] * m2[12];
        this.tempm[13] = m1[12] * m2[1] + m1[13] * m2[5] + m1[14] * m2[9] + m1[15] * m2[13];
        this.tempm[14] = m1[12] * m2[2] + m1[13] * m2[6] + m1[14] * m2[10] + m1[15] * m2[14];
        this.tempm[15] = m1[12] * m2[3] + m1[13] * m2[7] + m1[14] * m2[11] + m1[15] * m2[15];
        this.clone(m1, this.tempm);
    }

    private void invert(double[] m) {
        double a0 = m[0];
        double a5 = m[5];
        double a1 = m[1];
        double a4 = m[4];
        double b0 = a0 * a5 - a1 * a4;
        double a10 = m[10];
        double a15 = m[15];
        double a11 = m[11];
        double a14 = m[14];
        double b11 = a10 * a15 - a11 * a14;
        double a6 = m[6];
        double a2 = m[2];
        double b1 = a0 * a6 - a2 * a4;
        double a9 = m[9];
        double a13 = m[13];
        double b10 = a9 * a15 - a11 * a13;
        double a7 = m[7];
        double a3 = m[3];
        double b2 = a0 * a7 - a3 * a4;
        double b9 = a9 * a14 - a10 * a13;
        double b3 = a1 * a6 - a2 * a5;
        double a8 = m[8];
        double a12 = m[12];
        double b8 = a8 * a15 - a11 * a12;
        double b4 = a1 * a7 - a3 * a5;
        double b7 = a8 * a14 - a10 * a12;
        double b5 = a2 * a7 - a3 * a6;
        double b6 = a8 * a13 - a9 * a12;
        double det = b0 * b11 - b1 * b10 + b2 * b9 + b3 * b8 - b4 * b7 + b5 * b6;
        if (det == 0.0) {
            return;
        }
        det = 1.0 / det;
        m[0] = (a5 * b11 - a6 * b10 + a7 * b9) * det;
        m[1] = (a2 * b10 - a1 * b11 - a3 * b9) * det;
        m[2] = (a13 * b5 - a14 * b4 + a15 * b3) * det;
        m[3] = (a10 * b4 - a9 * b5 - a11 * b3) * det;
        m[4] = (a6 * b8 - a4 * b11 - a7 * b7) * det;
        m[5] = (a0 * b11 - a2 * b8 + a3 * b7) * det;
        m[6] = (a14 * b2 - a12 * b5 - a15 * b1) * det;
        m[7] = (a8 * b5 - a10 * b2 + a11 * b1) * det;
        m[8] = (a4 * b10 - a5 * b8 + a7 * b6) * det;
        m[9] = (a1 * b8 - a0 * b10 - a3 * b6) * det;
        m[10] = (a12 * b4 - a13 * b2 + a15 * b0) * det;
        m[11] = (a9 * b2 - a8 * b4 - a11 * b0) * det;
        m[12] = (a5 * b7 - a4 * b9 - a6 * b6) * det;
        m[13] = (a0 * b9 - a1 * b7 + a2 * b6) * det;
        m[14] = (a13 * b1 - a12 * b3 - a14 * b0) * det;
        m[15] = (a8 * b3 - a9 * b1 + a10 * b0) * det;
    }

    private void applyMatrix(double[] m) {
        for (int i = 0; i < this.vertCount; i += 3) {
            double x = this.verts[i];
            double y = this.verts[i + 1];
            double z = this.verts[i + 2];
            double w = 1.0;
            this.verts[i] = x * m[0] + y * m[4] + z * m[8] + w * m[12];
            this.verts[i + 1] = x * m[1] + y * m[5] + z * m[9] + w * m[13];
            this.verts[i + 2] = x * m[2] + y * m[6] + z * m[10] + w * m[14];
        }
    }

    private void fillTriangle(double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3) {
        double area = 0.0;
        double depth = 0.0;
        int maxX = (int)Math.min(Math.max(x1, Math.max(x2, x3)), (double)(this.width - 1));
        int maxY = (int)Math.min(Math.max(y1, Math.max(y2, y3)), (double)(this.height - 1));
        int minX = (int)Math.max(Math.min(x1, Math.min(x2, x3)), 0.0);
        int minY = (int)Math.max(Math.min(y1, Math.min(y2, y3)), 0.0);
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                double px = x;
                double py = y;
                double a = (x3 - x2) * -(py - y2) - -(y3 - y2) * (px - x2);
                double b = (x1 - x3) * -(py - y3) - -(y1 - y3) * (px - x3);
                double c = (x2 - x1) * -(py - y1) - -(y2 - y1) * (px - x1);
                if (!(a >= 0.0) || !(b >= 0.0) || !(c >= 0.0) || !((depth = (a * z1 + b * z2 + c * z3) / (a + b + c)) >= this.zbuffer[x + y * this.width])) continue;
                this.zbuffer[x + y * this.width] = depth;
                if (this.boundTexture) {
                    this.gc.setAlphaRGB(this.texture.map(x, y));
                }
                this.gc.drawLine(x, y, x, y);
            }
        }
    }
}

