/*
 * Decompiled with CFR 0.152.
 */
package com.mascotcapsule.micro3d.v3;

public class Vector3D {
    public int x;
    public int y;
    public int z;

    public Vector3D() {
        this.x = 0;
        this.y = 0;
        this.z = 0;
    }

    public Vector3D(Vector3D v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
    }

    public Vector3D(int X, int Y, int Z) {
        this.x = X;
        this.y = Y;
        this.z = Z;
    }

    public final int getX() {
        return this.x;
    }

    public final int getY() {
        return this.y;
    }

    public final int getZ() {
        return this.z;
    }

    public final void setX(int X) {
        this.x = X;
    }

    public final void setY(int Y) {
        this.y = Y;
    }

    public final void setZ(int Z) {
        this.z = Z;
    }

    public final void set(Vector3D v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
    }

    public final void set(int X, int Y, int Z) {
        this.x = X;
        this.y = Y;
        this.z = Z;
    }

    public final void unit() {
        double X = (double)this.x / 4096.0;
        double Y = (double)this.y / 4096.0;
        double Z = (double)this.z / 4096.0;
        double len = Math.sqrt(X * X + Y * Y + Z * Z);
        this.x = (int)(X / len * 4096.0);
        this.y = (int)(Y / len * 4096.0);
        this.z = (int)(Z / len * 4096.0);
    }

    public final int innerProduct(Vector3D v) {
        double X = (double)this.x / 4096.0;
        double Y = (double)this.y / 4096.0;
        double Z = (double)this.z / 4096.0;
        return (int)(X * (double)v.x + Y * (double)v.y + Z * (double)v.z) * 4096;
    }

    public final void outerProduct(Vector3D v) {
        double X = (double)this.x / 4096.0;
        double Y = (double)this.y / 4096.0;
        double Z = (double)this.z / 4096.0;
        this.x = (int)(Y * (double)v.z - Z * (double)v.y) * 4096;
        this.y = (int)(Z * (double)v.x - X * (double)v.z) * 4096;
        this.z = (int)(X * (double)v.y - Y * (double)v.x) * 4096;
    }

    public static final int innerProduct(Vector3D a, Vector3D b) {
        double aX = (double)a.x / 4096.0;
        double aY = (double)a.y / 4096.0;
        double aZ = (double)a.z / 4096.0;
        return (int)(aX * (double)b.x + aY * (double)b.y + aZ * (double)b.z) * 4096;
    }

    public static final Vector3D outerProduct(Vector3D a, Vector3D b) {
        Vector3D t = new Vector3D(a);
        t.outerProduct(b);
        return t;
    }
}

