/*
 * Decompiled with CFR 0.152.
 */
package com.mascotcapsule.micro3d.v3;

import com.mascotcapsule.micro3d.v3.Util3D;
import com.mascotcapsule.micro3d.v3.Vector3D;

public class AffineTrans {
    public int m00;
    public int m01;
    public int m02;
    public int m03;
    public int m10;
    public int m11;
    public int m12;
    public int m13;
    public int m20;
    public int m21;
    public int m22;
    public int m23;

    public AffineTrans() {
        this.m03 = 0;
        this.m02 = 0;
        this.m01 = 0;
        this.m00 = 0;
        this.m13 = 0;
        this.m12 = 0;
        this.m11 = 0;
        this.m10 = 0;
        this.m23 = 0;
        this.m22 = 0;
        this.m21 = 0;
        this.m20 = 0;
    }

    public AffineTrans(int m00, int m01, int m02, int m03, int m10, int m11, int m12, int m13, int m20, int m21, int m22, int m23) {
        this.m00 = m00;
        this.m01 = m01;
        this.m02 = m02;
        this.m03 = m03;
        this.m10 = m10;
        this.m11 = m11;
        this.m12 = m12;
        this.m13 = m13;
        this.m20 = m20;
        this.m21 = m21;
        this.m22 = m22;
        this.m23 = m23;
    }

    public AffineTrans(AffineTrans a) {
        this.m00 = a.m00;
        this.m01 = a.m01;
        this.m02 = a.m02;
        this.m03 = a.m03;
        this.m10 = a.m10;
        this.m11 = a.m11;
        this.m12 = a.m12;
        this.m13 = a.m13;
        this.m20 = a.m20;
        this.m21 = a.m21;
        this.m22 = a.m22;
        this.m23 = a.m23;
    }

    public AffineTrans(int[][] a) {
        this.m00 = a[0][0];
        this.m01 = a[0][1];
        this.m02 = a[0][2];
        this.m03 = a[0][3];
        this.m10 = a[1][0];
        this.m11 = a[1][1];
        this.m12 = a[1][2];
        this.m13 = a[1][3];
        this.m20 = a[2][0];
        this.m21 = a[2][1];
        this.m22 = a[2][2];
        this.m23 = a[2][3];
    }

    public AffineTrans(int[] a) {
        this.m00 = a[0];
        this.m01 = a[1];
        this.m02 = a[2];
        this.m03 = a[3];
        this.m10 = a[4];
        this.m11 = a[5];
        this.m12 = a[6];
        this.m13 = a[7];
        this.m20 = a[8];
        this.m21 = a[9];
        this.m22 = a[10];
        this.m23 = a[11];
    }

    public AffineTrans(int[] a, int offset) {
        this.m00 = a[offset + 0];
        this.m01 = a[offset + 1];
        this.m02 = a[offset + 2];
        this.m03 = a[offset + 3];
        this.m10 = a[offset + 4];
        this.m11 = a[offset + 5];
        this.m12 = a[offset + 6];
        this.m13 = a[offset + 7];
        this.m20 = a[offset + 8];
        this.m21 = a[offset + 9];
        this.m22 = a[offset + 10];
        this.m23 = a[offset + 11];
    }

    public final void get(int[] a) {
        a[0] = this.m00;
        a[1] = this.m01;
        a[2] = this.m02;
        a[3] = this.m03;
        a[4] = this.m10;
        a[5] = this.m11;
        a[6] = this.m12;
        a[7] = this.m13;
        a[8] = this.m20;
        a[9] = this.m21;
        a[10] = this.m22;
        a[11] = this.m23;
    }

    public final void get(int[] a, int offset) {
        a[offset + 0] = this.m00;
        a[offset + 1] = this.m01;
        a[offset + 2] = this.m02;
        a[offset + 3] = this.m03;
        a[offset + 4] = this.m10;
        a[offset + 5] = this.m11;
        a[offset + 6] = this.m12;
        a[offset + 7] = this.m13;
        a[offset + 8] = this.m20;
        a[offset + 9] = this.m21;
        a[offset + 10] = this.m22;
        a[offset + 11] = this.m23;
    }

    public final void set(int[] a, int offset) {
        this.m00 = a[offset + 0];
        this.m01 = a[offset + 1];
        this.m02 = a[offset + 2];
        this.m03 = a[offset + 3];
        this.m10 = a[offset + 4];
        this.m11 = a[offset + 5];
        this.m12 = a[offset + 6];
        this.m13 = a[offset + 7];
        this.m20 = a[offset + 8];
        this.m21 = a[offset + 9];
        this.m22 = a[offset + 10];
        this.m23 = a[offset + 11];
    }

    public final void set(int m00, int m01, int m02, int m03, int m10, int m11, int m12, int m13, int m20, int m21, int m22, int m23) {
        this.m00 = m00;
        this.m01 = m01;
        this.m02 = m02;
        this.m03 = m03;
        this.m10 = m10;
        this.m11 = m11;
        this.m12 = m12;
        this.m13 = m13;
        this.m20 = m20;
        this.m21 = m21;
        this.m22 = m22;
        this.m23 = m23;
    }

    public final void set(AffineTrans a) {
        this.m00 = a.m00;
        this.m01 = a.m01;
        this.m02 = a.m02;
        this.m03 = a.m03;
        this.m10 = a.m10;
        this.m11 = a.m11;
        this.m12 = a.m12;
        this.m13 = a.m13;
        this.m20 = a.m20;
        this.m21 = a.m21;
        this.m22 = a.m22;
        this.m23 = a.m23;
    }

    public final void set(int[][] a) {
        this.m00 = a[0][0];
        this.m01 = a[0][1];
        this.m02 = a[0][2];
        this.m03 = a[0][3];
        this.m10 = a[1][0];
        this.m11 = a[1][1];
        this.m12 = a[1][2];
        this.m13 = a[1][3];
        this.m20 = a[2][0];
        this.m21 = a[2][1];
        this.m22 = a[2][2];
        this.m23 = a[2][3];
    }

    public final void set(int[] a) {
        this.m00 = a[0];
        this.m01 = a[1];
        this.m02 = a[2];
        this.m03 = a[3];
        this.m10 = a[4];
        this.m11 = a[5];
        this.m12 = a[6];
        this.m13 = a[7];
        this.m20 = a[8];
        this.m21 = a[9];
        this.m22 = a[10];
        this.m23 = a[11];
    }

    public final Vector3D transPoint(Vector3D v) {
        return this.transform(v);
    }

    public final Vector3D transform(Vector3D v) {
        double x = (double)v.x / 4096.0;
        double y = (double)v.y / 4096.0;
        double z = (double)v.z / 4096.0;
        int X = (int)(x * (double)this.m00 + y * (double)this.m10 + z * (double)this.m20);
        int Y = (int)(x * (double)this.m01 + y * (double)this.m11 + z * (double)this.m21);
        int Z = (int)(x * (double)this.m02 + y * (double)this.m12 + z * (double)this.m22);
        return new Vector3D(X, Y, Z);
    }

    public final void multiply(AffineTrans a) {
        this.mul(this, a);
    }

    public final void mul(AffineTrans a) {
        this.mul(this, a);
    }

    public final void multiply(AffineTrans a1, AffineTrans a2) {
        this.mul(a1, a2);
    }

    public final void mul(AffineTrans a1, AffineTrans a2) {
        double b00 = (double)a2.m00 / 4096.0;
        double b01 = (double)a2.m00 / 4096.0;
        double b02 = (double)a2.m00 / 4096.0;
        double b03 = (double)a2.m00 / 4096.0;
        double b10 = (double)a2.m00 / 4096.0;
        double b11 = (double)a2.m00 / 4096.0;
        double b12 = (double)a2.m00 / 4096.0;
        double b13 = (double)a2.m00 / 4096.0;
        double b20 = (double)a2.m00 / 4096.0;
        double b21 = (double)a2.m00 / 4096.0;
        double b22 = (double)a2.m00 / 4096.0;
        double b23 = (double)a2.m00 / 4096.0;
        int t00 = a1.m00 * a2.m00 + a1.m01 * a2.m10 + a1.m02 * a2.m20;
        int t01 = a1.m00 * a2.m01 + a1.m01 * a2.m11 + a1.m02 * a2.m21;
        int t02 = a1.m00 * a2.m02 + a1.m01 * a2.m12 + a1.m02 * a2.m22;
        int t03 = a1.m00 * a2.m03 + a1.m01 * a2.m13 + a1.m02 * a2.m23;
        int t10 = a1.m10 * a2.m00 + a1.m11 * a2.m10 + a1.m12 * a2.m20;
        int t11 = a1.m10 * a2.m01 + a1.m11 * a2.m11 + a1.m12 * a2.m21;
        int t12 = a1.m10 * a2.m02 + a1.m11 * a2.m12 + a1.m12 * a2.m22;
        int t13 = a1.m10 * a2.m03 + a1.m11 * a2.m13 + a1.m12 * a2.m23;
        int t20 = a1.m20 * a2.m00 + a1.m21 * a2.m10 + a1.m22 * a2.m20;
        int t21 = a1.m20 * a2.m01 + a1.m21 * a2.m11 + a1.m22 * a2.m21;
        int t22 = a1.m20 * a2.m02 + a1.m21 * a2.m12 + a1.m22 * a2.m22;
        int t23 = a1.m20 * a2.m03 + a1.m21 * a2.m13 + a1.m22 * a2.m23;
        this.m00 = t00;
        this.m01 = t01;
        this.m02 = t02;
        this.m03 = t03;
        this.m10 = t10;
        this.m11 = t11;
        this.m12 = t12;
        this.m13 = t13;
        this.m20 = t20;
        this.m21 = t21;
        this.m22 = t22;
        this.m23 = t23;
    }

    public final void setIdentity() {
        this.m00 = 4096;
        this.m01 = 0;
        this.m02 = 0;
        this.m03 = 0;
        this.m10 = 0;
        this.m11 = 4096;
        this.m12 = 0;
        this.m13 = 0;
        this.m20 = 0;
        this.m21 = 0;
        this.m22 = 4096;
        this.m23 = 0;
    }

    public final void setRotationX(int x) {
        this.rotationX(x);
    }

    public final void setRotationY(int y) {
        this.rotationY(y);
    }

    public final void setRotationZ(int z) {
        this.rotationZ(z);
    }

    public final void rotationV(Vector3D v, int r) {
        this.setRotation(v, r);
    }

    public final void rotationX(int x) {
        this.m00 = 1;
        this.m01 = 0;
        this.m02 = 0;
        this.m03 = 0;
        this.m10 = 0;
        this.m11 = Util3D.cos(x);
        this.m12 = Util3D.sin(x);
        this.m13 = 0;
        this.m20 = 0;
        this.m21 = -Util3D.sin(x);
        this.m22 = Util3D.cos(x);
        this.m23 = 0;
    }

    public final void rotationY(int y) {
        this.m00 = Util3D.cos(y);
        this.m01 = 0;
        this.m02 = -Util3D.sin(y);
        this.m03 = 0;
        this.m10 = 0;
        this.m11 = 1;
        this.m12 = 0;
        this.m13 = 0;
        this.m20 = Util3D.sin(y);
        this.m21 = 0;
        this.m22 = Util3D.cos(y);
        this.m23 = 0;
    }

    public final void rotationZ(int z) {
        this.m00 = Util3D.cos(z);
        this.m01 = Util3D.sin(z);
        this.m02 = 0;
        this.m03 = 0;
        this.m10 = -Util3D.sin(z);
        this.m11 = Util3D.cos(z);
        this.m12 = 0;
        this.m13 = 0;
        this.m20 = 0;
        this.m21 = 0;
        this.m22 = 1;
        this.m23 = 0;
    }

    public final void setRotation(Vector3D v, int r) {
        double Ux = (double)v.x / 4096.0;
        double Uy = (double)v.y / 4096.0;
        double Uz = (double)v.z / 4096.0;
        double theta = (double)r / 4096.0 * Math.PI * 2.0;
        double cost = Math.cos(theta);
        double sint = Math.sin(theta);
        double vLen = Math.sqrt(Ux * Ux + Uy * Uy + Uz * Uz);
        if (vLen != 0.0) {
            Ux /= vLen;
            Uy /= vLen;
            Uz /= vLen;
        } else {
            Uz = 0.0;
            Uy = 0.0;
            Ux = 0.0;
        }
        this.m00 = (int)((cost + Ux * Ux * (1.0 - cost)) * 4096.0);
        this.m01 = (int)((Ux * Uy * (1.0 - cost) - Uz * sint) * 4096.0);
        this.m02 = (int)((Ux * Uz * (1.0 - cost) + Uy * sint) * 4096.0);
        this.m03 = 0;
        this.m10 = (int)((Uy * Ux * (1.0 - cost) + Uz * sint) * 4096.0);
        this.m11 = (int)((cost + Uy * Uy * (1.0 - cost)) * 4096.0);
        this.m12 = (int)((Uy * Uz * (1.0 - cost) - Ux * sint) * 4096.0);
        this.m13 = 0;
        this.m20 = (int)((Uz * Ux * (1.0 - cost) - Uy * sint) * 4096.0);
        this.m21 = (int)((Uz * Uy * (1.0 - cost) + Ux * sint) * 4096.0);
        this.m22 = (int)((cost + Uz * Uz * (1.0 - cost)) * 4096.0);
        this.m23 = 0;
    }

    public final void setViewTrans(Vector3D pos, Vector3D look, Vector3D up) {
        this.lookAt(pos, look, up);
    }

    public final void lookAt(Vector3D pos, Vector3D look, Vector3D up) {
        double Ux = (double)up.x / 4096.0;
        double Uy = (double)up.y / 4096.0;
        double Uz = (double)up.z / 4096.0;
        double Zx = (double)(pos.x - look.x) / 4096.0;
        double Zy = (double)(pos.y - look.y) / 4096.0;
        double Zz = (double)(pos.z - look.z) / 4096.0;
        double vLen = Math.sqrt(Zx * Zx + Zy * Zy + Zz * Zz);
        if (vLen != 0.0) {
            Zx /= vLen;
            Zy /= vLen;
            Zz /= vLen;
        } else {
            Zz = 0.0;
            Zy = 0.0;
            Zx = 0.0;
        }
        double Xx = Zy * Uz - Zz * Uy;
        double Xy = Zz * Ux - Zx * Uz;
        double Xz = Zx * Uy - Zy * Ux;
        vLen = Math.sqrt(Xx * Xx + Xy * Xy + Xz * Xz);
        if (vLen != 0.0) {
            Xx /= vLen;
            Xy /= vLen;
            Xz /= vLen;
        } else {
            Xz = 0.0;
            Xy = 0.0;
            Xx = 0.0;
        }
        double Yx = Zy * Xz - Zz * Xy;
        double Yy = Zz * Xx - Zx * Xz;
        double Yz = Zx * Xy - Zy * Xx;
        this.m00 = (int)(Xx * 4096.0);
        this.m01 = (int)(Xy * 4096.0);
        this.m02 = (int)(Xz * 4096.0);
        this.m03 = 0;
        this.m10 = (int)(Yx * 4096.0);
        this.m11 = (int)(Yy * 4096.0);
        this.m12 = (int)(Yz * 4096.0);
        this.m13 = 0;
        this.m20 = (int)(Zx * 4096.0);
        this.m21 = (int)(Zy * 4096.0);
        this.m22 = (int)(Zz * 4096.0);
        this.m23 = 0;
    }
}

